#pragma once

#include <string>

inline const std::string AUTOCONFIG = R"#(
########################################################################################
AUTOGENERATED HYPR CONFIG.
PLEASE USE THE CONFIG PROVIDED IN THE GIT REPO /examples/hypr.conf AND EDIT IT,
OR EDIT THIS ONE ACCORDING TO THE WIKI INSTRUCTIONS.
########################################################################################

autogenerated=1 # remove this line to get rid of the warning on top.

gaps_in=5
border_size=1
gaps_out=20
rounding=0
max_fps=60 # max fps for updates of config & animations
focus_when_hover=1 # 0 - do not switch the focus when hover (only for tiling)
main_mod=SUPER # For moving, resizing
intelligent_transients=1 # keeps transients always on top.
no_unmap_saving=1 # disables saving unmapped windows (seems to break sometimes)
scratchpad_mon=0 # self-explanatory

# Layout
layout=0 # 0 - dwindle (default), 1 - master
layout {
    no_gaps_when_only=0 # disables gaps and borders when only window on screen
}

# Bar config
Bar {
    height=20
    monitor=0
    enabled=1
    mod_pad_in=8
    no_tray_saving=1 # using this doesnt save the tray between reloads but fixes an issue with the bar disappearing.

    font.main=Noto Sans
    font.secondary=Noto Sans

    col.bg=0xff111111
    col.high=0xffff3333

    module=left,X,0xff8000ff,0xffffffff,1,workspaces
    module=pad,left,10
    module=left,,0xff7000dd,0xff7000dd,1,tray
    module=right,X,0xffffffff,0xff00ff33,1000,$date +%a,\ %b\ %Y\ \ %I:%M\ %p$
}

# colors
col.active_border=0x77ff3333
col.inactive_border=0x77222222

# animations
Animations {
    enabled=1
    speed=5 # for workspaces
    window_resize_speed=5 # for windows
    cheap=1 # highly recommended
    borders=0
    workspaces=0 # not really recommended
}

# keybinds
bind=SUPER,R,exec,dmenu_run
bind=SUPER,T,exec,alacritty
bind=SUPER,M,exec,pkill Hypr
bind=SUPER,RETURN,exec,xterm
bind=SUPER,G,exec,google-chrome-stable

bind=SUPER,C,killactive,

bind=SUPER,F,fullscreen,

bind=SUPER,1,workspace,1
bind=SUPER,2,workspace,2
bind=SUPER,3,workspace,3
bind=SUPER,4,workspace,4
bind=SUPER,5,workspace,5
bind=SUPER,6,workspace,6
bind=SUPER,7,workspace,7
bind=SUPER,8,workspace,8
bind=SUPER,9,workspace,9
)#";