﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="NativeConstants.cs" company="HandBrake Project (http://handbrake.fr)">
//   This file is part of the HandBrake source code - It may be used under the terms of the GNU General Public License.
// </copyright>
// <summary>
//   Defines the NativeConstants type.
// </summary>
// <auto-generated> Disable Stylecop Warnings for this file  </auto-generated>
// --------------------------------------------------------------------------------------------------------------------

namespace HandBrake.Interop.HbLib
{
	public class NativeConstants
	{
		// Audio encoders
		public const uint HB_ACODEC_MASK = 0x00FFFF00;
		public const uint HB_ACODEC_LAME = 0x00000200;
		public const uint HB_ACODEC_VORBIS = 0x00000400;
		public const uint HB_ACODEC_AC3 = 0x00000800;
		public const uint HB_ACODEC_LPCM = 0x00001000;
		public const uint HB_ACODEC_DCA = 0x00002000;
		public const uint HB_ACODEC_CA_AAC = 0x00004000;
		public const uint HB_ACODEC_CA_HAAC = 0x00008000;
		public const uint HB_ACODEC_FFAAC = 0x00010000;
		public const uint HB_ACODEC_FFMPEG = 0x00020000;
		public const uint HB_ACODEC_DCA_HD = 0x00040000;
		public const uint HB_ACODEC_MP3 = 0x00080000;
		public const uint HB_ACODEC_FFFLAC = 0x00100000;
		public const uint HB_ACODEC_FFFLAC24 = 0x00200000;
		public const uint HB_ACODEC_FDK_AAC = 0x00400000;
		public const uint HB_ACODEC_FDK_HAAC = 0x00800000;
		public const uint HB_ACODEC_FF_MASK = 0x00FF2800;
		public const uint HB_ACODEC_PASS_FLAG = 0x40000000;
		public const uint HB_ACODEC_PASS_MASK = (HB_ACODEC_MP3 | HB_ACODEC_FFAAC | HB_ACODEC_DCA_HD | HB_ACODEC_AC3 | HB_ACODEC_DCA);
		public const uint HB_ACODEC_AUTO_PASS = (HB_ACODEC_PASS_MASK | HB_ACODEC_PASS_FLAG);
		public const uint HB_ACODEC_MP3_PASS = (HB_ACODEC_MP3 | HB_ACODEC_PASS_FLAG);
		public const uint HB_ACODEC_AAC_PASS = (HB_ACODEC_FFAAC | HB_ACODEC_PASS_FLAG);
		public const uint HB_ACODEC_AC3_PASS = (HB_ACODEC_AC3 | HB_ACODEC_PASS_FLAG);
		public const uint HB_ACODEC_DCA_PASS = (HB_ACODEC_DCA | HB_ACODEC_PASS_FLAG);
		public const uint HB_ACODEC_DCA_HD_PASS = (HB_ACODEC_DCA_HD | HB_ACODEC_PASS_FLAG);
		public const uint HB_ACODEC_ANY = (HB_ACODEC_MASK | HB_ACODEC_PASS_FLAG);

		// Encode state
		public const int HB_STATE_IDLE = 1;
		public const int HB_STATE_SCANNING = 2;
		public const int HB_STATE_SCANDONE = 4;
		public const int HB_STATE_WORKING = 8;
		public const int HB_STATE_PAUSED = 16;
		public const int HB_STATE_WORKDONE = 32;
		public const int HB_STATE_MUXING = 64;
	}
}
