//
//  NevoAI.m
//  Gridlock
//
//  Created by Brian on 10/16/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import "NevoAI.h"


@implementation NevoAI

-(int)utilityForPlayer:(int)pnum inGame:(Game *)game {
  int utility = 100*[game scoreForPlayer:pnum];
  // score is most important, but also add utility points for pieces moving forward
  /*
  NSEnumerator *pe = [[game grid] enumeratorForPositionsWithValue:pnum];
  id pos;
  while (pos=[pe nextObject]) {
    int r = [pos row];
    if (pnum==2) r = [game numberOfRows]-1-r;
    utility += (10+r);
  }
   */
  NSArray *positions = [[[game grid] allPositionsWithValue:pnum] sortedArrayUsingKey_:@"row"];
  utility += 10*[positions count];
  int i;
  for(i=0; i<4 && i<[positions count]; i++) {
    int index = (pnum==1) ? i : [positions count]-1-i;
    int r = [[positions objectAtIndex:index] row];
    if (pnum==2) r = [game numberOfRows]-1-r;
    utility += 5*r;
  }
  
  if (pnum==1) return utility;
  
  positions = [positions sortedArrayUsingKey_:@"column"];
  if ([positions count]>2) {
    // penalize for being spread out
    utility -= ([[positions lastObject] column]-[[positions objectAtIndex:0] column]);
  }
  return utility;
}

-(int)relativeUtilityForGame:(Game *)game player:(int)pnum {
  int oppnum = [game playerNumberMovingAfterPlayer:pnum];
  return [self utilityForPlayer:pnum inGame:game]-[self utilityForPlayer:oppnum inGame:game];
}
@end
