/* GrandPerspective, Version 3.2 
 *   A utility for Mac OS X that graphically shows disk usage. 
 * Copyright (C) 2005-2022, Erwin Bonsma 
 * 
 * This program is free software; you can redistribute it and/or modify it 
 * under the terms of the GNU General Public License as published by the Free 
 * Software Foundation; either version 2 of the License, or (at your option) 
 * any later version. 
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT 
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for 
 * more details. 
 * 
 * You should have received a copy of the GNU General Public License along 
 * with this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA. 
 */

#import <Cocoa/Cocoa.h>

@class NamedFilter;
@class FilterRepository;
@class FilterEditor;
@class FilterPopUpControl;

@interface FilterSelectionPanelControl : NSWindowController {
  IBOutlet NSPopUpButton  *filterPopUp;
  IBOutlet NSButton  *applyDefaultFilterCheckbox;

  FilterRepository  *filterRepository;

  FilterEditor  *filterEditor;
  FilterPopUpControl  *filterPopUpControl;
}

// Override designated initialisers
- (instancetype) initWithWindow:(NSWindow *)window NS_UNAVAILABLE;
- (instancetype) initWithCoder:(NSCoder *)coder NS_UNAVAILABLE;

- (instancetype) init;
- (instancetype) initWithFilterRepository:(FilterRepository *)filterRepository NS_DESIGNATED_INITIALIZER;

- (IBAction) editFilter:(id)sender;
- (IBAction) addFilter:(id)sender;

- (IBAction) okAction:(id)sender;
- (IBAction) cancelAction:(id)sender;

- (void) selectFilterNamed:(NSString *)name;

/* Specifies if the user should be able to choose if the default filter is applied as well. It
 * should only be enabled when 1) there is a default filter, and 2) the user initiates a new scan
 * (instead of applying a filter to an existing view).
 */
- (void) enableApplyDefaultFilterOption:(BOOL)enable;

/* Returns the filter that has been selected.
 */
@property (nonatomic, readonly, strong) NamedFilter *selectedNamedFilter;

/* Returns if the default filter should be applied (next to the selected filter)
 */
@property (nonatomic, readonly) BOOL applyDefaultFilter;

@end
