#ifndef ANGULARUNITS_H
#define ANGULARUNITS_H

#include <cmath>
#include <QDebug>

class AngularUnits
{
public:
	AngularUnits() : _code(0), _f(NAN) {}
	AngularUnits(int code);

	bool operator==(const AngularUnits &other) const
	  {return (_code == other._code && _f == other._f);}

	bool isNull() const {return std::isnan(_f);}
	bool isValid() const {return !std::isnan(_f);}

	double toDegrees(double val) const;
	double fromDegrees(double val) const;

#ifndef QT_NO_DEBUG
	friend QDebug operator<<(QDebug dbg, const AngularUnits &au);
#endif // QT_NO_DEBUG
private:
	int _code;
	double _f;
};

#ifndef QT_NO_DEBUG
QDebug operator<<(QDebug dbg, const AngularUnits &au);
#endif // QT_NO_DEBUG

#endif // ANGULARUNITS_H
