/*
**  ViewingViewController.m
**
**  Copyright (c) 2001-2004
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "ViewingViewController.h"

#include "Constants.h"
#include "HeadersWindowController.h"
#include "NSUserDefaults+Extensions.h"

#ifndef MACOSX
#include "ViewingView.h"
#endif

static ViewingViewController *singleInstance = nil;

@implementation ViewingViewController

//
//
//
- (id) initWithNibName: (NSString *) theName
{
  self = [super init];

#ifdef MACOSX
  
  if (![NSBundle loadNibNamed: theName  owner: self])
    {
      NSDebugLog(@"Fatal error occured while loading the ViewingView nib file");
      AUTORELEASE(self);
      return nil;
    }

  RETAIN(view);

#else
  // We link our view
  view = [[ViewingView alloc] initWithParent: self];
  [view layoutView];

  // We link our outlets
  highlightURLs = ((ViewingView *)view)->highlightURLs;
  hideDeletedMessages = ((ViewingView *)view)->hideDeletedMessages;
  hideReadMessages = ((ViewingView *)view)->hideReadMessages;
  doubleClickPopUpButton = ((ViewingView *)view)->doubleClickPopUpButton;
#endif

  // We initialize our array containing all our headers
  _shownHeaders = [[NSMutableArray alloc] init];

  // We get our defaults for this panel
  [self initializeFromDefaults];

  return self;
}


//
//
//
- (void) dealloc
{
  singleInstance = nil;
  
  RELEASE(_shownHeaders);
  RELEASE(view);

  [super dealloc];
}


//
// action methods
//
- (IBAction) headersButtonClicked: (id) sender
{
  HeadersWindowController *aHeadersWindowController;
  int result;

  aHeadersWindowController = [[HeadersWindowController alloc]
			       initWithWindowNibName: @"HeadersWindow"];

  [aHeadersWindowController setShownHeaders: _shownHeaders];
  [aHeadersWindowController setShowAllHeadersButtonState: _showAllHeadersButtonState];
  
  result = [NSApp runModalForWindow: [aHeadersWindowController window]];
  
  // We must update our preferences
  if (result == NSRunStoppedResponse)
    {
      [_shownHeaders removeAllObjects];
      [_shownHeaders addObjectsFromArray: [aHeadersWindowController shownHeaders]];
      _showAllHeadersButtonState = [aHeadersWindowController showAllHeadersButtonState];
    }

  // We release our controller
  RELEASE(aHeadersWindowController);
}


//
// access methods
//
- (NSImage *) image
{
  NSBundle *aBundle;
  
  aBundle = [NSBundle bundleForClass: [self class]];
  
  return AUTORELEASE([[NSImage alloc] initWithContentsOfFile:
					[aBundle pathForResource: @"viewing" ofType: @"tiff"]]);
}

- (NSString *) name
{
  return _(@"Viewing");
}

- (NSView *) view
{
  return view;
}

- (BOOL) hasChangesPending
{
  return YES;
}


//
//
//
- (void) initializeFromDefaults
{
  NSUserDefaults *aUserDefaults;
  NSArray *values;

  aUserDefaults = [NSUserDefaults standardUserDefaults];

  [hideDeletedMessages setState: [aUserDefaults integerForKey: @"HIDE_DELETED_MESSAGES"  default: NSOnState]];
  [hideReadMessages setState: [aUserDefaults integerForKey: @"HIDE_READ_MESSAGES"  default: NSOffState]];
  [highlightURLs setState: [aUserDefaults integerForKey: @"HIGHLIGHT_URL"  default: NSOffState]];
  _showAllHeadersButtonState = [aUserDefaults integerForKey: @"SHOWALLHEADERS"  default: NSOffState];
  [doubleClickPopUpButton selectItemAtIndex: [aUserDefaults integerForKey: @"DOUBLECLICKACTION"  default: ACTION_VIEW_MESSAGE]];

  // We load the headers we want to show
  values = [aUserDefaults objectForKey: @"SHOWNHEADERS"];
  
  if (values)
    {
      [_shownHeaders addObjectsFromArray: values];
    }
}


//
//
//
- (void) saveChanges
{
  NSUserDefaults *aUserDefaults;
  
  aUserDefaults = [NSUserDefaults standardUserDefaults];
  
  [aUserDefaults setInteger: [hideDeletedMessages state]  forKey: @"HIDE_DELETED_MESSAGES"];
  [aUserDefaults setInteger: [hideReadMessages state]  forKey: @"HIDE_READ_MESSAGES"];
  [aUserDefaults setInteger: [highlightURLs state]  forKey: @"HIGHLIGHT_URL"];
  [aUserDefaults setInteger: _showAllHeadersButtonState  forKey: @"SHOWALLHEADERS"];
  [aUserDefaults setInteger: [doubleClickPopUpButton indexOfSelectedItem]  forKey: @"DOUBLECLICKACTION"];
  [aUserDefaults setObject: _shownHeaders  forKey: @"SHOWNHEADERS"];
}


//
// class methods
//
+ (id) singleInstance
{
  if (!singleInstance)
    {
      singleInstance = [[ViewingViewController alloc] initWithNibName: @"ViewingView"];
    }

  return singleInstance;
}

@end
