# Contributing

There are many ways to contribute:

* [Suggest an enhancement or discuss an issue on github](https://github.com/lwouis/fat-drive-sorter/issues), or use the feedback form in the app.
* [Localize the app in your language](https://poeditor.com/join/project/TTqkcdPO9V)

## Technical overview

This document gives a technical overview of the project, for newcomers who want to contribute.

## Building the project locally

This project has minimal dependency on Xcode-only features (e.g. InterfaceBuilder, Playgrounds). You can build it by doing:

* `scripts/codesign/setup_local.sh` to generate a local self-signed certificate
* Either open `fat-drive-sorter.xcworkspace` with XCode, or use the cli: `xcodebuild -workspace fat-drive-sorter.xcworkspace -scheme Debug` to build the .app with the `Debug` build configuration

## Raising a pull-request

If you want to contribute a PR, please run `npm install` once. It will add the pre-commit hook to ensure that your commits follow the convention and will pass the PR.

## This project specifically

To mitigate the issues listed above, we took some measures.

We minimize reliance on XCode, InterfaceBuilder, Playground, and other GUI tools. You can’t cut the dependency completely though as only XCode can build macOS apps. Currently, the project has these files:

* 1 xib (InterfaceBuilder UI file, describing the menubar items like “Edit” or “Format”)
* `fat-drive-sorter.xcodeproj` file describing FatDriveSorter itself. It contains some settings for the app
* `fat-drive-sorter.xcworkspace` file describing an xcode workspace containing FatDriveSorter + cocoapods dependencies. You open that file to open the project in XCode or AppCode
* `fat-drive-sorter.entitlements` and Info.plist which are static files describing some app config for XCode
* `PodFile` and `PodFile.lock` describe dependencies on open-source libraries (e.g. [Sparkle](https://github.com/sparkle-project/Sparkle))
* Some `.xcconfig` files in `config/` which contain XCode settings that people typically change using XCode UI, but that I want to be version controlled

The project directory is organized in the following way:

| Path               | Role                                                        |
|--------------------|-------------------------------------------------------------|
| `config/`          | XCode build settings                                        |
| `docs/`            | supporting material to document the project                 |
| `resources/`       | files that are shipped inside the final `.app` (e.g. icons) |
| `scripts/`         | bash scripts useful for CI and local workflows              |
| `src/`             | Swift source code                                           |
| `src/api-wrappers` | Wrapping some unfriendly APIs (usually C-APIs)              |
| `src/logic`        | Business logic (i.e. "models")                              |
| `src/ui`           | UI code (e.g. sublasses of NSView or NSCollectionView)      |

Other folders/files are either tooling or auto-generated (e.g. `Pods/` and `Frameworks/` are generated by `pod install`)
