RCS_ID("$Id: FFImageWindowTitled.m 488 2005-09-25 15:11:21Z ravemax $")

#import "FFImageWindowTitled.h"
#import "NSToolbar_Additions.h"
#import "FFSegmentedControl.h"
#import "FFToolbarUtil.h"
#import "FFImageList.h"
#import "FFImageListController.h"
#import "FFOptions.h"

// The toolbar item identifiers
static NSString* ImageSelectIdent   = @"tb_img_select";
static NSString* FullscreenIdent	= @"tb_fullscreen";
static NSString* FilelistIdent		= @"tb_filelist";
static NSString* MagLensIdent		= @"tb_mag_lens";

// Global toolbar delegate variables (required only onces) - initialize takes care of them
static NSArray* AllowedToolbarItemIdents = nil;
static NSArray* DefaultToolbarItemIdents = nil;

@implementation FFImageWindowTitled

#pragma mark -
#pragma mark Initialisation and cleanup

+ (void)initialize {
	if (AllowedToolbarItemIdents == nil) {
		AllowedToolbarItemIdents = [[NSArray alloc] initWithObjects:
			ImageSelectIdent,
			FullscreenIdent,
			FilelistIdent,
			MagLensIdent,
			nil];
		
		DefaultToolbarItemIdents = AllowedToolbarItemIdents; // may differ if more icons
	}
}

- (void)_setupToolbar {
	#define IMG_SEL_VIEW_NUM 2
	static const NSString* ImgSelectViewImages[IMG_SEL_VIEW_NUM] = {
		@"tb_previous", @"tb_next" };
	
	NSToolbar*  tb;
	
	tb = [[NSToolbar alloc] initWithIdentifier:@"titled_win_toolbar"];
	[tb setDelegate:self];
	[tb setAutosavesConfiguration:TRUE];
	
	// Toolbar items
	m_toolbarItems = [[NSMutableDictionary alloc] init];
	
	m_imgSelView = createSegmentedControl(IMG_SEL_VIEW_NUM, ImgSelectViewImages, NSSegmentSwitchTrackingMomentary, 
										  self, @selector(selectAOtherImage));

	addViewToToolbar(ImageSelectIdent, m_toolbarItems, m_imgSelView, FFTR(@"Image"), FFTR(@"Select an other image"));

/*	
	m_fullscreenBtn = createToolbarButton(FullscreenIdent, m_toolbarItems,
										  @"tb_fullscreen_normal", @"tb_fullscreen_pressed",
										  self, @selector(switchToFullscreen),
										  @"Fullscreen", @"Switches to fullscreen mode");
	
	m_filelistBtn = createToolbarButton(FilelistIdent, m_toolbarItems,
										@"tb_filelist_normal", @"tb_filelist_pressed",
										self, @selector(showOrHideFilelist),
										@"List", @"Shows or hides the image list");
	
*/
	createToolbarItem(FullscreenIdent, m_toolbarItems,
					  @"tb_fullscreen",
					  self, @selector(switchToFullscreen),
					  FFTR(@"Fullscreen"), FFTR(@"Switches to fullscreen mode"));

	createToolbarItem(FilelistIdent, m_toolbarItems,
					  @"tb_filelist",
					  self, @selector(showOrHideFilelist),
					  FFTR(@"List"), FFTR(@"Shows or hides the image list"));

	createToolbarItem(MagLensIdent, m_toolbarItems,
					  @"tb_mag_lens",
					  self, @selector(toggleMagnifyLens),
					  FFTR(@"Lens"), FFTR(@"Turns the magnifying lens on or off"));
	
 // Attach the toolbar to the window
	[self setToolbar:tb];	
}

#define WIN_STYLE (NSTitledWindowMask | NSMiniaturizableWindowMask | NSResizableWindowMask \
				   | NSClosableWindowMask | NSTexturedBackgroundWindowMask)

- (id)init {
	self = [super initWithContentRect:NSMakeRect(50.0, 50.0, 300.0, 200.0) andStyleMask:WIN_STYLE];
	if (self)
		[self _setupToolbar];
	return self;	
}

- (void)dealloc {
	[m_toolbarItems release];
	[m_imgSelView release];
//	[m_fullscreenBtn release];
//	[m_filelistBtn release];
		
	[[super toolbar] release];
	
	[super dealloc];
}

#pragma mark -
#pragma mark Toolbar delegate methods

- (NSToolbarItem*)toolbar:(NSToolbar*)tb itemForItemIdentifier:(NSString*)ident
willBeInsertedIntoToolbar:(BOOL)flag {
	return [m_toolbarItems objectForKey:ident];
}

- (NSArray*)toolbarAllowedItemIdentifiers:(NSToolbar*)tb {
	return AllowedToolbarItemIdents;
}

- (NSArray*)toolbarDefaultItemIdentifiers:(NSToolbar*)tb {
	return DefaultToolbarItemIdents;
}

#pragma mark -
#pragma mark Toolbar item actions

- (void)switchToFullscreen {
	[m_nc postNotificationName:ToggleScreenModeNotification object:nil];
}

- (void)selectAOtherImage {
	if ([m_imgSelView selectedSegment] == 0)
		[m_nc postNotificationName:SelectPreviousImageNotification object:nil];
	else
		[m_nc postNotificationName:SelectNextImageNotification object:nil];
}

- (void)showOrHideFilelist {
	[m_nc postNotificationName:ShowOrHideImageListWinNotification object:nil];
}

- (void)toggleMagnifyLens {
	[m_nc postNotificationName:ToggleMagnifyingLensVisibilityNotification object:nil];
}

#pragma mark -
#pragma mark View related methods

- (void)adjustViewSize:(NSSize)size refresh:(FFRefresh)refresh
	   keepAspectRatio:(BOOL)aratio andCenter:(BOOL)center {

	#define WINDOW_TITLEBAR_HEIGHT 22
	[self adjustViewSize:size
				minWidth:MIN_WINDOWTITLED_WIDTH
				 refresh:refresh 
		 keepAspectRatio:aratio 
			   andCenter:center];
}

- (float)widgetHeight {
	return (WINDOW_TITLEBAR_HEIGHT+[[self toolbar] viewHeight]);
}

@end
