RCS_ID("$Id: FFInputEventSheet.m 458 2005-07-16 19:27:58Z ravemax $")

#import "FFInputEventSheet.h"
#import "FFInputEvent.h"
#import "FFPreferences.h"
#import "NSPopUpButton_Additions.h"

#define NO_SPECIAL_KEY_SELECTED	0

@implementation FFInputEventSheet

- (id)init {
	self = [super init];
	if (self != nil)
		m_specialKeyIndexToKey = nil;

	return self;
}

- (void)dealloc {
	if (m_specialKeyIndexToKey != nil) {
		[m_specialKeyIndexToKey release];
		[m_synth release];
	}
	
	[super dealloc];
}

#pragma mark -
#pragma mark Input event <-> widgets (user editable outlets)

- (void)_setupSpecialKeysPopUpButtonAndSpeechSynthesizer {
	if (m_specialKeyIndexToKey == nil) {
		// Special key popup button
		m_specialKeyIndexToKey = [[FFInputEvent specialKeyKeys] retain];
		[m_keySpecial addItemsWithTitles:[FFInputEvent specialKeyNames]];

		// Speech synth
		m_synth = [[NSSpeechSynthesizer alloc] initWithVoice:nil];
	}
}

- (int)_keyToIndex:(unichar)code {
	int	i = 0, n = [m_specialKeyIndexToKey count];

	for (; i < n; i++)
		if ([[m_specialKeyIndexToKey objectAtIndex:i] unsignedShortValue] == code)
			return i+1; //+1 due to "<no key>"
	return 0;
}

- (void)_updateWidgetsWithInputEvent:(FFInputEvent*)ev {
	// Reset all widgets
	[m_keyModCmd setState:NSOffState];
	[m_keyModOpt setState:NSOffState];
	[m_keyModShift setState:NSOffState];
	[m_keyModCtrl setState:NSOffState];
	[m_keyModNum setState:NSOffState];
	[m_btnModOpt setState:NSOffState];
	[m_btnModShift setState:NSOffState];
	[m_btnModCtrl setState:NSOffState];
	[m_keyEquiv setStringValue:@""];
	[m_keySpecial selectItemAtIndex:NO_SPECIAL_KEY_SELECTED];
	[m_btnButton selectItemAtIndex:0];
	
	if ((ev == nil) || ([ev type] == EVENT_NONE)) {
		[m_type selectCellWithTag:EVENT_KEY];
		return;
	}

	[m_type selectCellWithTag:[ev type]];
	
	// Speech
	if ([ev type] == EVENT_SPEECH)
		[m_spCommand setStringValue:[ev command]];
	else {
		[m_spCommand setStringValue:@""];
		unsigned mod = [ev modifier];
		
		// Key
		if ([ev type] == EVENT_KEY) {
			if (mod & NSCommandKeyMask)		[m_keyModCmd setState:NSOnState];
			if (mod & NSAlternateKeyMask)	[m_keyModOpt setState:NSOnState];
			if (mod & NSShiftKeyMask)		[m_keyModShift setState:NSOnState];
			if (mod & NSControlKeyMask)		[m_keyModCtrl setState:NSOnState];
			if (mod & NSNumericPadKeyMask)	[m_keyModNum setState:NSOnState];

			int skidx =	[self _keyToIndex:[ev key]];
			if (skidx == NO_SPECIAL_KEY_SELECTED)
				[m_keyEquiv setStringValue:[NSString stringWithFormat:@"%C", [ev key]]];
			else
				[m_keySpecial selectItemAtIndex:skidx];

		// Button
		} else {
			if (mod & NSAlternateKeyMask)	[m_btnModOpt setState:NSOnState];
			if (mod & NSShiftKeyMask)		[m_btnModShift setState:NSOnState];
			if (mod & NSControlKeyMask)		[m_btnModCtrl setState:NSOnState];
			
			[m_btnButton selectItemWithTag:[ev button]];
		}
	}
}

- (FFInputEvent*)_widgetsToInputEvent {
	FFInputEvent*		ev		= [FFInputEvent event];
	FFInputEventType	type	= (FFInputEventType)[[m_type selectedCell] tag];

	[ev setType:type];

	// Speech
	if (type == EVENT_SPEECH) {
		if ([[m_spCommand stringValue] length] > 0)
			[ev setCommand:[m_spCommand stringValue]];
	
	} else {
		unsigned mod = 0;

		// Key
		if (type == EVENT_KEY) {
			int	ski = [m_keySpecial indexOfSelectedItem];
			if (ski == NO_SPECIAL_KEY_SELECTED) {
				if ([[m_keyEquiv stringValue] length] == 1)
					[ev setKey:[[m_keyEquiv stringValue] characterAtIndex:0]];
			} else
				[ev setKey:[[m_specialKeyIndexToKey objectAtIndex:(ski-1)] unsignedShortValue]];

			if ([m_keyModCmd state] == NSOnState)	mod |= NSCommandKeyMask;
			if ([m_keyModShift state] == NSOnState)	mod |= NSShiftKeyMask;
			if ([m_keyModOpt state] == NSOnState)	mod |= NSAlternateKeyMask;
			if ([m_keyModCtrl state] == NSOnState)	mod |= NSControlKeyMask;
			if ([m_keyModNum state] == NSOnState)	mod |= NSNumericPadKeyMask;

		// Button
		} else if (type == EVENT_BUTTON) {
			[ev setButton:[m_btnButton tagOfSelectedItem]];

			if ([m_btnModShift state] == NSOnState)	mod |= NSShiftKeyMask;
			if ([m_btnModOpt state] == NSOnState)	mod |= NSAlternateKeyMask;
			if ([m_btnModCtrl state] == NSOnState)	mod |= NSControlKeyMask;
		}
		
		if (mod > 0)
			[ev setModifier:mod];
	}

	return ev;
}

#pragma mark -
#pragma mark IB Actions

- (IBAction)accept:(id)sender {
	[NSApp stopModalWithCode:1];
}

- (IBAction)cancel:(id)sender {
	[NSApp stopModalWithCode:0];
}

- (IBAction)widgetModified:(id)sender {
	if (m_curEvent != nil)
		[m_curEvent release];
	m_curEvent = [self _widgetsToInputEvent];

	if (![m_curEvent isCompleteDoIgnoreAction:TRUE]) {
		m_curEvent = nil; // free (autorelease)
		[m_warning setStringValue:FFTR(@"Incomplete event")];
	} else if ([[FFPreferences instance] isInputEventAlreadyTaken:m_curEvent]) {
		m_curEvent = nil; // free (autorelease)
		[m_warning setStringValue:FFTR(@"Event already assigned to an different action")];
	} else {
		[m_curEvent retain];
		[m_warning setStringValue:@""];
	}
	
	[m_acceptButton setEnabled:(m_curEvent != nil)];
}

- (IBAction)testCommand:(id)sender {
	if ([[m_spCommand stringValue] length] > 0)
		[m_synth startSpeakingString:[m_spCommand stringValue]];
}

#pragma mark -
#pragma mark Textfield (keyequiv & speech command) delegate method

- (void)controlTextDidChange:(NSNotification*)notification {
	[self widgetModified:self]; // CPU load seems to be OK
}	
		
#pragma mark -
#pragma mark Exported methods

- (FFInputEvent*)getEventWithWindow:(NSWindow*)win andInputEvent:(FFInputEvent*)event {
	[self _setupSpecialKeysPopUpButtonAndSpeechSynthesizer];
	
	[m_warning setStringValue:@""]; // no warning
	[m_acceptButton setEnabled:FALSE];
	[self _updateWidgetsWithInputEvent:event];
	m_curEvent = nil;
		
	[NSApp beginSheet:m_win modalForWindow:win modalDelegate:self didEndSelector:NULL contextInfo:NULL];
	BOOL accept = [NSApp runModalForWindow:m_win]; // modal sheet!
    [NSApp endSheet:m_win];
    [m_win orderOut:NULL];
	
	return (accept ? m_curEvent : nil);
}

@end
