// $Id: FFDirectory.h 528 2005-10-22 12:29:54Z ravemax $
//
// Datasource, delegate for the filelist directory drawer

typedef enum {
	DIR_NORMAL	= 0,
	DIR_ARCHIVE,
	DIR_SMARTFOLDER,
	
	NUM_DIR_TYPES
} FFDirType;

#pragma mark -

@class FFSmartFolder;

@interface FFDirNode : NSObject {
	NSString*		m_completePath;
	NSString*		m_displayName;
	FFDirType		m_type;
	NSColor*		m_bgColor;
	NSImage*		m_img;

	NSMutableArray* m_subDirs; // NORMAL, SMARTFOLDER
	FFSmartFolder*	m_smartFolder; // SMARTFOLDER
	FFDirNode*		m_parentNode;
}

+ (FFDirNode*)directoryWithPath:(NSString*)path;
+ (FFDirNode*)archiveWithPath:(NSString*)path;
+ (FFDirNode*)smartFolderWithPath:(NSString*)path;
+ (FFDirNode*)removeableMediaWithPath:(NSString*)path;

- (NSString*)completePath;
- (NSString*)displayName;
- (FFDirType)type;
- (NSColor*)bgColor;
- (NSImage*)image;
- (FFDirNode*)parentNode; // May be nil if a root node
- (FFSmartFolder*)smartFolder; // Only when type==DIR_SMARTFOLDER else nil

- (unsigned)numberOfSubDirectories;
- (FFDirNode*)subDirectoryAtIndex:(unsigned)idx;
- (unsigned)indexOfSubDirectory:(FFDirNode*)node;
- (BOOL)isSelfOrParentNode:(FFDirNode*)node; // including itself
- (void)forgetSubDirectories;

@end

#pragma mark -

extern NSString* DirectoryContentChangedNotification;

@class FFImageList; // needed for file copying

@interface FFDirectory : NSObject {
	IBOutlet id		m_delegate;
	
	NSMutableArray*	m_nodes;
	FFImageList*	m_imgList;
}

- (id)init;
- (void)setImageList:(FFImageList*)list;
- (BOOL)containsRemovableMedia;

@end

#pragma mark -

@interface NSObject (FFDirectoryDelegate)

- (BOOL)directory:(FFDirectory*)dir shouldCollapseNode:(FFDirNode*)node;

@end
