RCS_ID("$Id: FFRecentList.m 610 2007-08-26 19:40:40Z ravemax $")

#import "FFRecentList.h"

@implementation FFRecentList

// Constants
static const unsigned MAX_NUMBER_OF_RECENT	= 5;
static NSString* UDName	= @"recent_list";

// Change notification
NSString* RecentListChangedNotification	= @"recent_list_changed";
#define POST_CHANGE_NOTIFICATION() \
	m_modified = TRUE; \
	[[NSNotificationCenter defaultCenter] postNotificationName:RecentListChangedNotification object:self]

- (id)initWithUserDefaults {
	self = [super init];
	if (self != nil) {
		m_list		= [[NSMutableArray alloc] initWithCapacity:MAX_NUMBER_OF_RECENT+1];
		m_modified	= FALSE;

		NSArray* sa = [[NSUserDefaults standardUserDefaults] stringArrayForKey:UDName];
		if (sa != nil)
			[m_list addObjectsFromArray:sa];
	}
	return self;
}

- (void)save {
	if (m_modified) {
		[[NSUserDefaults standardUserDefaults] setObject:m_list forKey:UDName];
		m_modified	= FALSE;
	}
}

- (void)dealloc {
	[m_list release];
	[super dealloc];
}

- (void)add:(NSString*)item {
	unsigned idx = [m_list indexOfObject:item];
	
	// Not in the list
	if (idx == NSNotFound) {
		if ([m_list count] == MAX_NUMBER_OF_RECENT)
			[m_list removeLastObject];
		[m_list insertObject:item atIndex:0];
		
		// Already in the list and not the first entry?
	} else if (idx > 0) {
		[m_list removeObjectAtIndex:idx];
		[m_list insertObject:item atIndex:0];
	}
	
	POST_CHANGE_NOTIFICATION();
}

- (void)clearAndSendNotification:(BOOL)doSend {
	[m_list removeAllObjects];
	if (doSend)
		POST_CHANGE_NOTIFICATION();
}

- (void)removeAtIndex:(unsigned)index {
	m_modified = TRUE;
	[m_list removeObjectAtIndex:index];
}

- (NSEnumerator*)itemEnumerator {
	return [m_list objectEnumerator];
}

- (NSString*)itemAtIndex:(unsigned)index {
	return [m_list objectAtIndex:index];
}

@end
