/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import java.io.Serializable;
import prpobjects.Pageid;
import prpobjects.Pagetype;
import prpobjects.PrpRootObject;
import prpobjects.Typeid;
import prpobjects.Uruobjectref;
import prpobjects.Urustring;
import prpobjects.prpfile;
import prpobjects.uruobj;
import shared.Format;
import shared.IBytestream;
import shared.m;
import uru.Bytedeque;
import uru.context;

public class Uruobjectdesc
extends uruobj
implements Serializable {
    byte flag;
    public Pageid pageid;
    public Pagetype pagetype;
    byte loadMask;
    public Typeid objecttype;
    public int objectnumber;
    public Urustring objectname;
    public int cloneId;
    public int clonePlayerId;
    public transient Uruobjectdesc rootobj;
    public static final int kHasCloneIDs = 1;
    public static final int kHasLoadMask = 2;

    public boolean hasCloneIds() {
        return (this.flag & 1) != 0;
    }

    public boolean hasLoadMask() {
        return (this.flag & 2) != 0;
    }

    public Uruobjectdesc(context c) {
        IBytestream data = c.in;
        this.rootobj = c.curRootObject;
        this.flag = data.readByte();
        this.pageid = new Pageid(c);
        if (c.readversion == 3) {
            this.pagetype = new Pagetype(c);
            if ((this.flag & 2) != 0) {
                this.loadMask = data.readByte();
            }
            this.objecttype = Typeid.Read(c);
            this.objectname = new Urustring(c);
            if ((this.flag & 1) != 0) {
                this.cloneId = c.readInt();
                this.clonePlayerId = c.readInt();
            }
        } else if (c.readversion == 4 || c.readversion == 7) {
            this.pagetype = new Pagetype(c);
            this.objecttype = Typeid.Read(c);
            this.objectnumber = data.readInt();
            this.objectname = new Urustring(c);
            if ((this.flag & 6) != 0) {
                this.loadMask = data.readByte();
            }
        } else if (c.readversion == 6) {
            this.pagetype = new Pagetype(c);
            if ((this.flag & 2) != 0) {
                this.loadMask = data.readByte();
            }
            this.objecttype = Typeid.Read(c);
            this.objectnumber = data.readInt();
            this.objectname = new Urustring(c);
            if ((this.flag & 1) != 0) {
                this.cloneId = c.readInt();
                this.clonePlayerId = c.readInt();
            }
        }
    }

    private Uruobjectdesc() {
    }

    public static Uruobjectdesc createDefaultWithTypeNamePrp(Typeid type, String name, prpfile prp) {
        return Uruobjectdesc.createDefaultWithTypeNamePagePagetype(type, name, prp.header.pageid, prp.header.pagetype);
    }

    public static Uruobjectdesc createDefaultWithTypeNamePage(Typeid type, String name, Pageid page) {
        return Uruobjectdesc.createDefaultWithTypeNamePagePagetype(type, name, page, Pagetype.createDefault());
    }

    public static Uruobjectdesc createDefaultWithTypeNamePagePagetype(Typeid type, String name, Pageid page, Pagetype pagetype) {
        Uruobjectdesc result = new Uruobjectdesc();
        result.flag = 0;
        result.objectname = Urustring.createFromString(name);
        result.objecttype = type;
        result.pageid = page;
        result.pagetype = pagetype;
        return result;
    }

    public Uruobjectref toRef() {
        Uruobjectref result = Uruobjectref.createFromUruobjectdesc(this);
        return result;
    }

    @Override
    public void compile(Bytedeque c) {
        if (c.format == Format.pots) {
            c.writeByte(this.flag);
            this.pageid.compile(c);
            this.pagetype.compile(c);
            if ((this.flag & 2) != 0) {
                c.writeByte(this.loadMask);
            }
            this.objecttype.compile(c);
            this.objectname.compile(c);
            if ((this.flag & 1) != 0) {
                c.writeInt(this.cloneId);
                c.writeInt(this.clonePlayerId);
            }
        } else if (c.format == Format.moul) {
            c.writeByte(this.flag);
            this.pageid.compile(c);
            this.pagetype.compile(c);
            if ((this.flag & 2) != 0) {
                c.writeByte(this.loadMask);
            }
            this.objecttype.compile(c);
            c.writeInt(this.objectnumber);
            this.objectname.compile(c);
            if ((this.flag & 1) != 0) {
                c.writeInt(this.cloneId);
                c.writeInt(this.clonePlayerId);
            }
        } else {
            m.throwUncaughtException("unimplemented");
        }
    }

    public String toString() {
        return this.objectname.toString() + "(" + this.objecttype.toString() + ")(" + this.pageid.toString() + ")";
    }

    public PrpRootObject getObjectDescribed(prpfile prp) {
        PrpRootObject result = prp.findObjectWithDesc(this);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Uruobjectdesc)) {
            return false;
        }
        Uruobjectdesc o = (Uruobjectdesc)obj;
        if (!this.objectname.equals(o.objectname)) {
            return false;
        }
        if (!this.objecttype.equals(o.objecttype)) {
            return false;
        }
        if (!this.pageid.equals(o.pageid)) {
            return false;
        }
        if (!this.pagetype.equals(o.pagetype)) {
            return false;
        }
        if (this.cloneId != o.cloneId) {
            return false;
        }
        return this.clonePlayerId == o.clonePlayerId;
    }

    public int hashCode() {
        int a = this.objectname.hashCode();
        int b2 = this.pageid.hashCode();
        int c = this.objecttype.hashCode();
        return this.objectname.hashCode() + this.pageid.hashCode() + this.objecttype.hashCode() + this.cloneId + this.clonePlayerId * 16;
    }

    public Uruobjectdesc deepClone() {
        Uruobjectdesc result = new Uruobjectdesc();
        this.copyInto(result);
        return result;
    }

    public void copyInto(Uruobjectdesc result) {
        result.flag = this.flag;
        result.objectname = this.objectname.deepClone();
        result.objectnumber = this.objectnumber;
        result.objecttype = this.objecttype;
        result.pageid = this.pageid.deepClone();
        result.pagetype = this.pagetype.deepClone();
        result.loadMask = this.loadMask;
        result.cloneId = this.cloneId;
        result.clonePlayerId = this.clonePlayerId;
    }
}

