/*
 * Decompiled with CFR 0.152.
 */
package SevenZip.Archive.SevenZip;

import SevenZip.Archive.SevenZip.ArchiveDatabase;
import SevenZip.Archive.SevenZip.FileItem;
import SevenZip.Archive.SevenZip.Folder;
import SevenZip.Archive.SevenZip.InArchiveInfo;
import SevenZipCommon.IntVector;
import SevenZipCommon.LongVector;
import java.io.IOException;

public class ArchiveDatabaseEx
extends ArchiveDatabase {
    public InArchiveInfo ArchiveInfo = new InArchiveInfo();
    public LongVector PackStreamStartPositions = new LongVector();
    public IntVector FolderStartPackStreamIndex = new IntVector();
    public IntVector FolderStartFileIndex = new IntVector();
    public IntVector FileIndexToFolderIndexMap = new IntVector();

    @Override
    void Clear() {
        super.Clear();
        this.ArchiveInfo.Clear();
        this.PackStreamStartPositions.clear();
        this.FolderStartPackStreamIndex.clear();
        this.FolderStartFileIndex.clear();
        this.FileIndexToFolderIndexMap.clear();
    }

    void FillFolderStartPackStream() {
        this.FolderStartPackStreamIndex.clear();
        this.FolderStartPackStreamIndex.Reserve(this.Folders.size());
        int startPos = 0;
        for (int i = 0; i < this.Folders.size(); ++i) {
            this.FolderStartPackStreamIndex.add(startPos);
            startPos += ((Folder)this.Folders.get((int)i)).PackStreams.size();
        }
    }

    void FillStartPos() {
        this.PackStreamStartPositions.clear();
        this.PackStreamStartPositions.Reserve(this.PackSizes.size());
        long startPos = 0L;
        for (int i = 0; i < this.PackSizes.size(); ++i) {
            this.PackStreamStartPositions.add(startPos);
            startPos += this.PackSizes.get(i);
        }
    }

    public void Fill() throws IOException {
        this.FillFolderStartPackStream();
        this.FillStartPos();
        this.FillFolderStartFileIndex();
    }

    public long GetFolderFullPackSize(int folderIndex) {
        int packStreamIndex = this.FolderStartPackStreamIndex.get(folderIndex);
        Folder folder = (Folder)this.Folders.get(folderIndex);
        long size = 0L;
        for (int i = 0; i < folder.PackStreams.size(); ++i) {
            size += this.PackSizes.get(packStreamIndex + i);
        }
        return size;
    }

    void FillFolderStartFileIndex() throws IOException {
        this.FolderStartFileIndex.clear();
        this.FolderStartFileIndex.Reserve(this.Folders.size());
        this.FileIndexToFolderIndexMap.clear();
        this.FileIndexToFolderIndexMap.Reserve(this.Files.size());
        int folderIndex = 0;
        int indexInFolder = 0;
        for (int i = 0; i < this.Files.size(); ++i) {
            boolean emptyStream;
            FileItem file = (FileItem)this.Files.get(i);
            boolean bl = emptyStream = !file.HasStream;
            if (emptyStream && indexInFolder == 0) {
                this.FileIndexToFolderIndexMap.add(-1);
                continue;
            }
            if (indexInFolder == 0) {
                while (true) {
                    if (folderIndex >= this.Folders.size()) {
                        throw new IOException("Incorrect Header");
                    }
                    this.FolderStartFileIndex.add(i);
                    if (this.NumUnPackStreamsVector.get(folderIndex) != 0) break;
                    ++folderIndex;
                }
            }
            this.FileIndexToFolderIndexMap.add(folderIndex);
            if (emptyStream || ++indexInFolder < this.NumUnPackStreamsVector.get(folderIndex)) continue;
            ++folderIndex;
            indexInFolder = 0;
        }
    }

    public long GetFolderStreamPos(int folderIndex, int indexInFolder) {
        return this.ArchiveInfo.DataStartPosition + this.PackStreamStartPositions.get(this.FolderStartPackStreamIndex.get(folderIndex) + indexInFolder);
    }
}

