/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Main;
import java.util.Vector;
import javax.swing.JPanel;
import shared.m;

public class Plugins {
    private static final String[] plugins = new String[]{"drizzleadjunct.AdjPlugin"};
    private static Vector<JPanel> panels = new Vector();
    private static String guititle = "";
    private static Vector<Runnable> guicallbacks = new Vector();

    public static void initialise() {
        for (String plugin : plugins) {
            try {
                Class<?> klass = Class.forName(plugin);
                m.msg("Loaded plugin: ", plugin);
            }
            catch (ClassNotFoundException e2) {
            }
            catch (Exception e3) {
                m.msg("Unexpected exception while loading plugin: ", plugin);
            }
        }
    }

    public static void initialiseGui() {
        for (JPanel panel : panels) {
            Main.guiform.tabs.addTab(panel.getName(), panel);
        }
        String newtitle = Main.guiform.getTitle() + guititle;
        Main.guiform.setTitle(newtitle);
    }

    public static void initialiseGui2() {
        for (Runnable r : guicallbacks) {
            try {
                r.run();
            }
            catch (Exception e2) {
                m.err("Error while loading plugin.");
                e2.printStackTrace();
            }
        }
    }

    public static void addGuiPanel(JPanel panel, String panelname) {
        panel.setName(panelname);
        panels.add(panel);
    }

    public static void appendTitle(String title) {
        guititle = guititle + " " + title;
    }

    public static void addGuiInitialisedCallback(Runnable r) {
        guicallbacks.add(r);
    }
}

