/*
 * Decompiled with CFR 0.152.
 */
package export3ds;

import shared.IBytedeque;
import shared.IBytestream;
import shared.m;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Typeid {
    unknown,
    primary,
    version,
    meshdata,
    material,
    matname,
    matambient,
    matdiffuse,
    matspecular,
    color24,
    namedobj,
    namedtriobj,
    pointarray,
    facearray,
    meshmatgroup,
    texturemap,
    texturefilename,
    uvcoords,
    uoffset,
    voffset,
    uscale,
    vscale;

    public static pair[] pairs;

    public static void verify() {
        for (pair p1 : pairs) {
            boolean foundint = false;
            boolean foundenum = false;
            for (pair p2 : pairs) {
                if (p1.i == p2.i) {
                    if (!foundint) {
                        foundint = true;
                    } else {
                        m.err("3ds typeid programming error.");
                    }
                }
                if (p1.type != p2.type) continue;
                if (!foundenum) {
                    foundenum = true;
                    continue;
                }
                m.err("3ds typeid programming error.");
            }
        }
    }

    public static Typeid read(IBytestream c) {
        short data = c.readShort();
        Typeid result = Typeid.getType(data);
        if (result == unknown) {
            boolean bl = false;
        }
        return result;
    }

    public static boolean has(short i) {
        for (pair p : pairs) {
            if (p.i != i) continue;
            return true;
        }
        return false;
    }

    public static pair p(short i, Typeid type) {
        return new pair(i, type);
    }

    public short getNum() {
        for (pair p : pairs) {
            if (p.type != this) continue;
            return p.i;
        }
        return unknown.getNum();
    }

    public static short getNum(Typeid type) {
        return type.getNum();
    }

    public static Typeid getType(short i) {
        for (pair p : pairs) {
            if (p.i != i) continue;
            return p.type;
        }
        m.warn("Unhandled type in Typeid.");
        return unknown;
    }

    public void compile(IBytedeque c) {
        c.writeShort(this.getNum());
    }

    static {
        pairs = new pair[]{Typeid.p((short)-1, unknown), Typeid.p((short)19789, primary), Typeid.p((short)2, version), Typeid.p((short)15677, meshdata), Typeid.p((short)-20481, material), Typeid.p((short)-24576, matname), Typeid.p((short)-24560, matambient), Typeid.p((short)-24544, matdiffuse), Typeid.p((short)-24528, matspecular), Typeid.p((short)17, color24), Typeid.p((short)16384, namedobj), Typeid.p((short)16640, namedtriobj), Typeid.p((short)16656, pointarray), Typeid.p((short)16672, facearray), Typeid.p((short)16688, meshmatgroup), Typeid.p((short)16704, uvcoords), Typeid.p((short)-24064, texturemap), Typeid.p((short)-23808, texturefilename), Typeid.p((short)-23720, uoffset), Typeid.p((short)-23718, voffset), Typeid.p((short)-23722, uscale), Typeid.p((short)-23724, vscale)};
    }

    public static class pair {
        short i;
        Typeid type;

        public pair(short i, Typeid type) {
            this.i = i;
            this.type = type;
        }
    }
}

