/*
 * Decompiled with CFR 0.152.
 */
package difflib.myers;

import difflib.ChangeDelta;
import difflib.Chunk;
import difflib.DeleteDelta;
import difflib.Delta;
import difflib.DiffAlgorithm;
import difflib.InsertDelta;
import difflib.Patch;
import difflib.myers.DiffNode;
import difflib.myers.DifferentiationFailedException;
import difflib.myers.PathNode;
import difflib.myers.Snake;
import java.lang.reflect.Array;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MyersDiff
implements DiffAlgorithm {
    @Override
    public Patch diff(List<?> original, List<?> revised) {
        return this.diff(original.toArray(), revised.toArray());
    }

    @Override
    public Patch diff(Object[] orig, Object[] rev) {
        try {
            PathNode path = MyersDiff.buildPath(orig, rev);
            return MyersDiff.buildRevision(path, orig, rev);
        }
        catch (DifferentiationFailedException e2) {
            e2.printStackTrace();
            return new Patch();
        }
    }

    public static PathNode buildPath(Object[] orig, Object[] rev) throws DifferentiationFailedException {
        if (orig == null) {
            throw new IllegalArgumentException("original sequence is null");
        }
        if (rev == null) {
            throw new IllegalArgumentException("revised sequence is null");
        }
        int N = orig.length;
        int M = rev.length;
        int MAX = N + M + 1;
        int size = 1 + 2 * MAX;
        int middle = (size + 1) / 2;
        PathNode[] diagonal = new PathNode[size];
        diagonal[middle + 1] = new Snake(0, -1, null);
        for (int d = 0; d < MAX; ++d) {
            for (int k = -d; k <= d; k += 2) {
                int j;
                int i;
                int kmiddle = middle + k;
                int kplus = kmiddle + 1;
                int kminus = kmiddle - 1;
                PathNode prev = null;
                if (k == -d || k != d && diagonal[kminus].i < diagonal[kplus].i) {
                    i = diagonal[kplus].i;
                    prev = diagonal[kplus];
                } else {
                    i = diagonal[kminus].i + 1;
                    prev = diagonal[kminus];
                }
                diagonal[kminus] = null;
                PathNode node = new DiffNode(i, j, prev);
                for (j = i - k; i < N && j < M && orig[i].equals(rev[j]); ++i, ++j) {
                }
                if (i > node.i) {
                    node = new Snake(i, j, node);
                }
                diagonal[kmiddle] = node;
                if (i < N || j < M) continue;
                return diagonal[kmiddle];
            }
            diagonal[middle + d - 1] = null;
        }
        throw new DifferentiationFailedException("could not find a diff path");
    }

    public static Patch buildRevision(PathNode path, Object[] orig, Object[] rev) {
        if (path == null) {
            throw new IllegalArgumentException("path is null");
        }
        if (orig == null) {
            throw new IllegalArgumentException("original sequence is null");
        }
        if (rev == null) {
            throw new IllegalArgumentException("revised sequence is null");
        }
        Patch patch2 = new Patch();
        if (path.isSnake()) {
            path = path.prev;
        }
        while (path != null && path.prev != null && path.prev.j >= 0) {
            if (path.isSnake()) {
                throw new IllegalStateException("bad diffpath: found snake when looking for diff");
            }
            int i = path.i;
            int j = path.j;
            path = path.prev;
            int ianchor = path.i;
            int janchor = path.j;
            Chunk original = new Chunk(ianchor, i - ianchor, MyersDiff.copyOfRange(orig, ianchor, i));
            Chunk revised = new Chunk(janchor, j - janchor, MyersDiff.copyOfRange(rev, janchor, j));
            Delta delta = null;
            delta = original.getSize() == 0 && revised.getSize() != 0 ? new InsertDelta(original, revised) : (original.getSize() > 0 && revised.getSize() == 0 ? new DeleteDelta(original, revised) : new ChangeDelta(original, revised));
            patch2.addDelta(delta);
            if (!path.isSnake()) continue;
            path = path.prev;
        }
        return patch2;
    }

    public static <T> T[] copyOfRange(T[] original, int from, int to) {
        return MyersDiff.copyOfRange(original, from, to, original.getClass());
    }

    public static <T, U> T[] copyOfRange(U[] original, int from, int to, Class<? extends T[]> newType) {
        int newLength = to - from;
        if (newLength < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        Object[] copy = newType == Object[].class ? new Object[newLength] : (Object[])Array.newInstance(newType.getComponentType(), newLength);
        System.arraycopy(original, from, copy, 0, Math.min(original.length - from, newLength));
        return copy;
    }
}

