FAQ
===

How to update the card database
---

When a new set comes out, you need to update your card database to be able to
see the new cards in the deck editor and use them in the game. To do this,
open the Oracle tool in the Cockatrice folder. It's a stand-alone program and
is run directly out of the folder without running Cockatrice.

When the Oracle tool is running, open the menu and select 'Download sets
information'. Use the suggested address and click OK. After at most a few
seconds, you should be presented a list of sets to be downloaded. Do not
uncheck the ones you already have: they should be downloaded again. Click
'Start download' and wait. When the process is finished, the database should
be up to date.


Change Card Art / Custom Card Art
---

Is it possible to change the card art for a specif card, not by changing the
set order in my deck editor?

YES! It is actually very simple.

All you have to do is get a .JPG of the card you wish to change and name the
actual file of the image to the cards (exact) name and add ”.Full” to the end.
You can then take this new card image and replace the old one in your
downloaded image folder.

*NOTE: Image size does not matter. Try to use a high resolution .JPG of the
card you want to use for best quality.*

EXAMPLE: Let's say you wish to turn your M11 Sun Titan from its original art
to a promo version. 

If you are using Windows 7, you can find the default location for the
Cockatrice card art files under 

```
C:\Program Files (x86)\Cockatrice\pics\downloadedPics
```

Once there, look for the folder of the
set for the card we are replacing. For this example, Sun Titan is in the M11
folder. Open the folder and paste/replace your new “Promo” Sun Titan.full[.JPG] 
into this folder, discarding the original copy. (If you have
not yet downloaded the original image of a card by selecting it in the deck
editor or playing it in an online game, the card image will not yet be there)

Once you have the new card image in the proper folder, you can now start
Cockatrice (Or re-start if you already had the program open)and select the
deck editor to see your new card image. 

If you are changing the art of a card that has multiple versions in other
sets, make sure you put the new card in whatever folder (or set) is highest
on your card database set list.

*NOTE: Other players on Cockatrice will NOT see your new card image. They will
only see whatever version of the card is in their database.*


Use Higher Resolution Cards
---

Can you get better/higher resolution card art than the default downloaded card
images already used?

Yes!

When you click on a card for the first time in the Deck Editor, Cockatrice
goes onto the internet and finds an image of that card from a database on
another website.

If you find a higher resolution .JPG of a card that you wish to use on your
Cockatrice, you can replace the image with no problem. If you can find a card
image in the 3,000 by 1,000 pixel range, and save it as the cards (exact) name
and add .Full to the end.

If you are using Windows 7, you can find the default location for the
Cockatrice card art files under 

```
C:\Program Files(x86)\Cockatrice\pics\downloadedPics
```

Once there, look for the folder of the set for the card you are replacing. If you are not running Cockatrice as an
administrator, look in 

```
C:\Users\username\AppData\Local\VirtualStore\Program Files (x86)\Cockatrice\pics\downloadedPics
```

Open the folder of the set with the card, and paste/replace the new higher
resolution .JPG image with the old low quality one.

This process is the same for changing cards to custom images.


*NOTE: Other Cockatrice players will not see your higher resolution card art,
they will only see the image they have in their own database.*


Booster Drafts
---
Cockatrice does not support booster drafts, so players need to use an
external service for this.

Most people use [ccgdecks.com](http://ccgdecks.com/) so it's probably not a bad idea to
register an account there before joining a game in Cockatrice. 


How to link a card in the Cockatrice chat.
---

To link a card in the Cockatrice chat, type out the full name of the card,
surrounded by the [card] and [/card] tags.

For example:

```
[card]Black Lotus[/card]
```

How to link a URL in the Cockatrice chat.
---
To link a URL in the Cockatrice chat, type out the url, surrounded by the
[url] and [/url] tags.

For example:

```
[url]http://www.cockatrice.de[/url]
[url]cockatrice.de[/url]
```

