#! /bin/sh
# copy framework to archive

PROJECT=~/Projects/Libraries/VHFExport				# project directory (the directory we have to copy)
ARCHIVEDIR=/Network/vhfInterservice/Projects/Cenon/Mac	# archive directory
ARCHIVENAME=VHFExport						# name of project folder

ARCHIVE=$ARCHIVEDIR/$ARCHIVENAME
BACKUP=$ARCHIVEDIR/_$ARCHIVENAME

echo Copy files from $PROJECT to Archive

# backup archive
echo Removing old Backup / Creating new Backup
rm -rf $BACKUP
mv $ARCHIVE $BACKUP

# copy files
cd $PROJECT
echo Copying files
for fn in `find	. \
  -type d \( -name '*~' -o -name '_*' -o -name 'build' \) -prune \
  -o -type f \( -name '*~' -o -name '*.backup' -o -name '*.o' -o -name '_*' -o -name '.*' \
                -o ! -name '*.icns' -a ! -name '*.sh' -a ! -name 'Makefile*' \) \
  -o -type l \
  -o -print`
do
  if [ -d $fn ]; then		# directory
     case $fn in
     *.nib )
       echo cp $fn
       cp -R $fn $ARCHIVE/$fn
       chmod ug+x $ARCHIVE/$fn ;;
     *.pbproj )
       echo cp $fn
       cp -R $fn $ARCHIVE/$fn
       chmod ug+x $ARCHIVE/$fn ;;
     * )
       echo mkdir $fn
       mkdir -p $ARCHIVE/$fn
       chmod ug+x $ARCHIVE/$fn ;;
     esac
  else
       echo cp $fn
       cp $fn $ARCHIVE/$fn
       chmod ug+r $ARCHIVE/$fn
  fi
done

echo 'Ready'