/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.NumberAssert;
import org.fest.assertions.PrimitiveAssert;

public class IntAssert
extends PrimitiveAssert
implements NumberAssert {
    private static final int ZERO = 0;
    private final int actual;

    protected IntAssert(int actual) {
        this.actual = actual;
    }

    public IntAssert as(String description) {
        this.description(description);
        return this;
    }

    public IntAssert describedAs(String description) {
        return this.as(description);
    }

    public IntAssert as(Description description) {
        this.description(description);
        return this;
    }

    public IntAssert describedAs(Description description) {
        return this.as(description);
    }

    public IntAssert isEqualTo(int expected) {
        if (this.actual == expected) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    public IntAssert isNotEqualTo(int other) {
        if (this.actual != other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, other));
    }

    public IntAssert isGreaterThan(int other) {
        if (this.actual > other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThanOrEqualTo(this.actual, other));
    }

    public IntAssert isLessThan(int other) {
        if (this.actual < other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThanOrEqualTo(this.actual, other));
    }

    public IntAssert isGreaterThanOrEqualTo(int other) {
        if (this.actual >= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedLessThan(this.actual, other));
    }

    public IntAssert isLessThanOrEqualTo(int other) {
        if (this.actual <= other) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedGreaterThan(this.actual, other));
    }

    public IntAssert isZero() {
        return this.isEqualTo(0);
    }

    public IntAssert isPositive() {
        return this.isGreaterThan(0);
    }

    public IntAssert isNegative() {
        return this.isLessThan(0);
    }

    public IntAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }
}

