/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.incremental.recomp;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class GroovySourceFileClassNameConverter {
    private final Multimap<String, String> sourceClassesMapping;
    private final Map<String, String> classSourceMapping;

    public GroovySourceFileClassNameConverter(Multimap<String, String> sourceClassesMapping) {
        this.sourceClassesMapping = sourceClassesMapping;
        this.classSourceMapping = this.constructReverseMapping(sourceClassesMapping);
    }

    private Map<String, String> constructReverseMapping(Multimap<String, String> sourceClassesMapping) {
        return sourceClassesMapping.entries().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public Collection<String> getClassNames(String sourceFileRelativePath) {
        return this.sourceClassesMapping.get((Object)sourceFileRelativePath);
    }

    boolean isEmpty() {
        return this.classSourceMapping.isEmpty();
    }

    Optional<String> getRelativeSourcePath(String fqcn) {
        return Optional.ofNullable(this.classSourceMapping.get(fqcn));
    }
}

