/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.orfjackal.retrolambda.asm.ClassReader;
import net.orfjackal.retrolambda.asm.ClassVisitor;
import net.orfjackal.retrolambda.asm.MethodVisitor;
import net.orfjackal.retrolambda.asm.Type;
import net.orfjackal.retrolambda.ext.ow2asm.EnhancedClassReader;
import net.orfjackal.retrolambda.interfaces.ClassInfo;
import net.orfjackal.retrolambda.interfaces.MethodInfo;
import net.orfjackal.retrolambda.interfaces.MethodKind;
import net.orfjackal.retrolambda.interfaces.MethodRef;
import net.orfjackal.retrolambda.interfaces.MethodSignature;
import net.orfjackal.retrolambda.lambdas.Handles;
import net.orfjackal.retrolambda.lambdas.LambdaNaming;
import net.orfjackal.retrolambda.lambdas.Types;
import net.orfjackal.retrolambda.util.Bytecode;
import net.orfjackal.retrolambda.util.Flags;

public class ClassAnalyzer {
    private final Map<Type, ClassInfo> classes = new HashMap<Type, ClassInfo>();
    private final Map<MethodRef, MethodRef> relocatedMethods = new HashMap<MethodRef, MethodRef>();
    private final Map<MethodRef, MethodRef> renamedLambdaMethods = new HashMap<MethodRef, MethodRef>();

    public void analyze(byte[] bytecode, boolean isJavacHacksEnabled) {
        this.analyze(EnhancedClassReader.create(bytecode, isJavacHacksEnabled));
    }

    public void analyze(ClassReader cr) {
        ClassInfo c = new ClassInfo(cr);
        this.classes.put(c.type, c);
        if (Flags.isInterface(cr.getAccess())) {
            this.analyzeInterface(c, cr);
        } else {
            this.analyzeClass(c, cr);
        }
        this.analyzeClassOrInterface(c, cr);
    }

    private void analyzeClass(final ClassInfo c, ClassReader cr) {
        cr.accept(new ClassVisitor(327680){
            private String owner;

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.owner = name;
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                int tag = Flags.isConstructor(name) ? 7 : (Flags.isStaticMethod(access) ? 6 : 5);
                c.addMethod(access, new MethodRef(tag, this.owner, name, desc), new MethodKind.Implemented());
                return null;
            }
        }, 1);
    }

    private void analyzeInterface(final ClassInfo c, ClassReader cr) {
        cr.accept(new ClassVisitor(327680){
            private String owner;
            private String companion;

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.owner = name;
                this.companion = name + "$";
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodRef method = new MethodRef(Handles.accessToTag(access, true), this.owner, name, desc);
                if (Flags.isAbstractMethod(access)) {
                    c.addMethod(access, method, new MethodKind.Abstract());
                } else if (ClassAnalyzer.isDefaultMethod(access)) {
                    MethodRef defaultImpl = new MethodRef(6, this.companion, name, Bytecode.prependArgumentType(desc, Type.getObjectType(this.owner)));
                    c.enableCompanionClass();
                    c.addMethod(access, method, new MethodKind.Default(defaultImpl));
                } else if (ClassAnalyzer.isInstanceLambdaImplMethod(access)) {
                    ClassAnalyzer.this.relocatedMethods.put(method, new MethodRef(6, this.companion, name, Bytecode.prependArgumentType(desc, Type.getObjectType(this.owner))));
                    c.enableCompanionClass();
                } else if (Flags.isStaticMethod(access) && !Flags.isStaticInitializer(name, desc, access)) {
                    ClassAnalyzer.this.relocatedMethods.put(method, new MethodRef(6, this.companion, name, desc));
                    c.enableCompanionClass();
                }
                return null;
            }
        }, 1);
    }

    private void analyzeClassOrInterface(ClassInfo c, ClassReader cr) {
        cr.accept(new ClassVisitor(327680){
            private String owner;

            @Override
            public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
                this.owner = name;
            }

            @Override
            public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
                MethodRef method = new MethodRef(Handles.accessToTag(access, true), this.owner, name, desc);
                if (LambdaNaming.isBodyMethod(access, name) && Flags.isPrivateMethod(access) && Flags.isInstanceMethod(access)) {
                    desc = Types.prependArgumentType(Type.getObjectType(this.owner), desc);
                    ClassAnalyzer.this.renamedLambdaMethods.put(method, new MethodRef(6, this.owner, name, desc));
                }
                return null;
            }
        }, 1);
    }

    private static boolean isDefaultMethod(int access) {
        return !Flags.isAbstractMethod(access) && !Flags.isStaticMethod(access) && Flags.isPublicMethod(access);
    }

    private static boolean isInstanceLambdaImplMethod(int access) {
        return !Flags.isAbstractMethod(access) && !Flags.isStaticMethod(access) && Flags.isPrivateMethod(access);
    }

    public List<ClassInfo> getInterfaces() {
        return this.classes.values().stream().filter(ClassInfo::isInterface).collect(Collectors.toList());
    }

    public List<ClassInfo> getClasses() {
        return this.classes.values().stream().filter(ClassInfo::isClass).collect(Collectors.toList());
    }

    private ClassInfo getClass(Type type) {
        return this.classes.getOrDefault(type, new ClassInfo());
    }

    public MethodRef getMethodCallTarget(MethodRef original) {
        MethodRef impl;
        if (original.tag == 7 && (impl = this.getMethodDefaultImplementation(original)) != null) {
            return impl;
        }
        return this.relocatedMethods.getOrDefault(original, original);
    }

    public MethodRef getRenamedLambdaMethod(MethodRef original) {
        return this.renamedLambdaMethods.getOrDefault(original, original);
    }

    public MethodRef getMethodDefaultImplementation(MethodRef interfaceMethod) {
        MethodSignature signature = interfaceMethod.getSignature();
        for (MethodInfo method : this.getDefaultMethods(Type.getObjectType(interfaceMethod.owner))) {
            if (!method.signature.equals(signature)) continue;
            return method.getDefaultMethodImpl();
        }
        return null;
    }

    public Optional<Type> getCompanionClass(Type type) {
        return this.getClass(type).getCompanionClass();
    }

    public List<MethodInfo> getDefaultMethods(Type type) {
        return this.getMethods(type).stream().filter(m -> m.kind instanceof MethodKind.Default).collect(Collectors.toList());
    }

    public Collection<MethodInfo> getMethods(Type type) {
        ClassInfo c = this.getClass(type);
        HashMap<MethodSignature, MethodInfo> methods = new HashMap<MethodSignature, MethodInfo>();
        for (Type iface : c.getInterfaces()) {
            for (MethodInfo m : this.getMethods(iface)) {
                if (this.isAlreadyInherited(m, methods)) continue;
                methods.put(m.signature, m);
            }
        }
        if (c.superclass != null) {
            for (MethodInfo m : this.getMethods(c.superclass)) {
                if (this.isAlreadyInherited(m, methods)) continue;
                methods.put(m.signature, m);
            }
        }
        for (MethodInfo m : c.getMethods()) {
            methods.put(m.signature, m);
        }
        return methods.values();
    }

    private boolean isAlreadyInherited(MethodInfo subject, Map<MethodSignature, MethodInfo> existingMethods) {
        MethodInfo existing = existingMethods.get(subject.signature);
        return existing != null && this.getAllInterfaces(existing.owner).contains(subject.owner);
    }

    private Set<Type> getAllInterfaces(Type interfaceType) {
        assert (this.getClass(interfaceType).isInterface()) : "not interface: " + interfaceType;
        HashSet<Type> results = new HashSet<Type>();
        results.add(interfaceType);
        for (Type parentInterface : this.getClass(interfaceType).getInterfaces()) {
            results.addAll(this.getAllInterfaces(parentInterface));
        }
        return results;
    }
}

