/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;

public class GroupDrawData
extends DrawData {
    public int headerWidth;
    public int headerHeight;
    public Rectangle headerArea;
    static final int GROUP_X = 2;
    static final int GROUP_PAD = 1;
    static final int GROUP_HEADER_X = 9;
    static final int GROUP_HEADER_PAD = 2;

    public GroupDrawData() {
        this.state = new int[1];
    }

    @Override
    void draw(Theme theme, GC gC, Rectangle rectangle) {
        int n = theme.frameHandle;
        int n2 = OS.gtk_widget_get_style(n);
        int n3 = gC.getGCData().drawable;
        theme.transferClipping(gC, n2);
        int n4 = OS.gtk_style_get_xthickness(n2);
        int n5 = OS.gtk_style_get_ythickness(n2);
        int n6 = rectangle.x;
        int n7 = rectangle.y + this.headerHeight / 2;
        int n8 = rectangle.width;
        int n9 = rectangle.height - this.headerHeight / 2;
        byte[] byArray = Converter.wcsToMbcs(null, "frame", true);
        int n10 = n4 + 2;
        int n11 = this.headerWidth + 2;
        int n12 = 2;
        int n13 = this.getStateType(0);
        OS.gtk_paint_shadow_gap(n2, n3, n13, 3, null, n, byArray, n6, n7, n8, n9, n12, n10, n11);
        if (this.headerArea != null) {
            this.headerArea.x = rectangle.x + n10 + 1;
            this.headerArea.y = rectangle.y;
            this.headerArea.width = this.headerWidth;
            this.headerArea.height = this.headerHeight;
        }
        if (this.clientArea != null) {
            this.clientArea.x = rectangle.x + n4;
            this.clientArea.y = rectangle.y + n5 + this.headerHeight;
            this.clientArea.width = rectangle.width - 2 * n4;
            this.clientArea.height = rectangle.height - 2 * n5 - this.headerHeight;
        }
    }

    @Override
    int getStateType(int n) {
        int n2 = this.state[n];
        int n3 = 0;
        if ((n2 & 0x20) != 0) {
            n3 = 4;
        }
        return n3;
    }

    @Override
    int hit(Theme theme, Point point, Rectangle rectangle) {
        return rectangle.contains(point) ? 0 : -1;
    }
}

