/*
 * Decompiled with CFR 0.152.
 */
package net.orfjackal.retrolambda.interfaces;

import java.util.Objects;
import net.orfjackal.retrolambda.asm.Handle;
import net.orfjackal.retrolambda.asm.Type;
import net.orfjackal.retrolambda.google.common.base.MoreObjects;
import net.orfjackal.retrolambda.interfaces.MethodSignature;
import net.orfjackal.retrolambda.lambdas.Handles;

public final class MethodRef {
    public final int tag;
    public final String owner;
    public final String name;
    public final String desc;

    public MethodRef(int tag, Class<?> owner, String name, String desc) {
        this(tag, Type.getInternalName(owner), name, desc);
    }

    public MethodRef(int tag, String owner, String name, String desc) {
        this.tag = tag;
        this.owner = owner;
        this.name = name;
        this.desc = desc;
    }

    public MethodSignature getSignature() {
        return new MethodSignature(this.name, this.desc);
    }

    public int getOpcode() {
        return Handles.getOpcode(this.toHandle());
    }

    public Handle toHandle() {
        return new Handle(this.tag, this.owner, this.name, this.desc, this.tag == 9);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MethodRef)) {
            return false;
        }
        MethodRef that = (MethodRef)obj;
        return this.owner.equals(that.owner) && this.name.equals(that.name) && this.desc.equals(that.desc);
    }

    public int hashCode() {
        return Objects.hash(this.owner, this.name, this.desc);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).addValue(this.owner).addValue(this.name).addValue(this.desc).addValue("(" + this.tag + ")").toString();
    }
}

