<p align="center">
  <img src="https://cloud.githubusercontent.com/assets/499192/10754100/c0e1cc4c-7c95-11e5-9d3b-842d3acc2fd5.gif">
</p>

# Aerial - Apple TV Aerial Views Screen Saver

![Github All Releases](https://img.shields.io/github/downloads/johncoates/aerial/total.svg?maxAge=86400)
![GitHub contributors](https://img.shields.io/github/contributors/johncoates/aerial.svg?maxAge=2592000)

Aerial is a Mac screensaver (macOS 10.12 or later) based on the new Apple TV screensaver that displays the Aerial movies Apple shot over New York, San Francisco, Hawaii, China, etc. Starting with version 2.0.0, it also includes videos shared by Joshua Michaels & Hal Bergman!

Aerial is completely open source, so feel free to contribute to its development.

This repository is used **solely** for development.

Starting with version 2.3.0, Aerial can now display current weather information *and* forecasts to your location, thanks to [OpenWeather](https://openweathermap.org). 

![openweather_logo](https://user-images.githubusercontent.com/37544189/115738975-d689bf80-a38d-11eb-809b-fbb019e6ed08.png)

We thank [OpenWeather](https://openweathermap.org) for their support of Open Source projects. 

# For downloads and instructions, please go to our new website, hosted on GitHub Page: https://aerialscreensaver.github.io

> Windows user? Try [OrangeJedi/Aerial](https://github.com/OrangeJedi/Aerial) <br>
> Linux user? Try [graysky2/xscreensaver-aerial](https://github.com/graysky2/xscreensaver-aerial/)

## About Aerial 

Aerial was started in 2015 by John Coates ([Twitter](https://twitter.com/JohnCoatesDev), [Email](mailto:john@johncoates.me))

Starting with version 1.4, Aerial is maintained by [Guillaume Louel](https://github.com/glouel) ([Twitter](https://twitter.com/C_Wiz)). If you are looking to support the development of Aerial, feel free to donate using the following button :

[![ko-fi](https://ko-fi.com/img/githubbutton_sm.svg)](https://ko-fi.com/A0A32385Y)


## Compatibility

- macOS Sierra (10.12) and above, natively compiled for Apple Silicon

## Community

- **Found a bug?** Make sure you are running the latest version and please check our [FAQ](https://aerialscreensaver.github.io/faq.html) and [troubleshooting page](Documentation/Troubleshooting.md) and [our issues](https://github.com/JohnCoates/Aerial/issues), as someone may already have reported it (a beta may be available with the fix you need). Feel free to [open an issue](https://github.com/JohnCoates/Aerial/issues/new), try to be as specific as possible.
- **Have you fixed a bug?** Or want to implement a feature? Check instructions on how to compile Aerial and more on [contributing here](Documentation/Contribute.md).
- **Can you translate videos names and their descriptions?** Awesome! [Read here for details](Resources/Community/Readme.md) on how to help us.
- **Have a feature request?** [Open an issue](https://github.com/JohnCoates/Aerial/issues/new). Tell us why it would be useful, and why you and others would want it.
- **Join our [Community Discord server](https://discord.gg/TPuA5WG)** for technical support, feature requests, and a fun time!

## Multilingual Support

Aerial features overlay descriptions of the main geographical features displayed in the videos.

![Community Strings example](https://user-images.githubusercontent.com/4295/52958947-75bd6180-3395-11e9-947f-3c77d9f41928.jpg)

Video descriptions are available in many languages (Spanish, French, Polish… [check the complete list here](Resources/Community/Readme.md)) and that is only possible thanks to the collaboration and interested work of many volunteers. To best serve the international community we've defined a translation workflow that allows any person, even with **no technical background** to help translate the descriptions.

If you want to collaborate, please [read the details here](Resources/Community/Readme.md).

## License

[MIT License](https://raw.githubusercontent.com/JohnCoates/Aerial/master/LICENSE)

