# Frequently Asked Questions

This guide is meant to help you get started and answer some of the most common questions. If you wish to search for a specific term, please type `Command` + `F` and search for a single word such as "favorites".

<hr> 

## How do I install Aerial?

If this is your first time on GitHub or you are not a "power user" we reccomend the following setup:

1. Navigate to the [latest releases](https://github.com/glouel/AerialCompanion/releases)
2. Select `AerialInstaller.dmg` on the most recent release (which is on the top). Disregard the remaining files/assets.
3. Navigate to your Downloads folder (or wherever you chose to save `AerialInstaller.dmg`)
4. Double click on `AerialInstaller.dmg` 
5. It will momentarily pause to open the DMG file.
6. You will then see a window that prompts you to drag `Aerial.app` to the `Applications` folder. Please do so. 

![Drag and Drop](https://user-images.githubusercontent.com/18543749/90923714-24dc5e00-e3bc-11ea-9a24-a650f42ea734.gif)

7. Now double click on the `Applications` folder that you just dragged the icon to. 
8. Find and double click on `Aerial.app` 
9. This will launch and install Aerial. You will notice a small circle in your menubar (at the top of your screen)
10. Lastly, go to the menubar, click on the icon and select `Open screen saver settings...`

<img width="150" alt="Screen Saver Settings" src="https://user-images.githubusercontent.com/18543749/90923886-77b61580-e3bc-11ea-97c6-ac90647f2e71.png">

11. Click on the "Screen Saver" tab at the top of System Preferences
12. And select Aerial on the left hand side. 
13. You're all set! If you want to change your settings, simply click on `Screen Saver Options...` on the right hand side. 
14. You can now eject (delete) `AerialInstaller.dmg`

<hr>

## How do I change my settings?

1. Open System Preferences 
2. Click on Desktop & Screen Saver in System Preferences 

<img width="128" alt="Desktop and Screen Saver Prefs" src="https://user-images.githubusercontent.com/18543749/90852443-831a2a00-e345-11ea-81ce-48b7632cd537.png">

3. Scroll down until you see "Aerial" in the left hand panel
4. Click on `Screen Saver Options` 

<img width="200" alt="Screen Saver Options" src="https://user-images.githubusercontent.com/18543749/90852516-aa70f700-e345-11ea-89f3-0323eb24ebd1.png">

5. Now you are ready to manage your Aerial settings! 

<hr> 

## Videos not playing

If you have a selection of videos you want to play, but they aren't playing check the following: 

- *Have you selected the videos you want to play?*
- *Have you cached the videos you want to play?* 

#### Have you selected the videos you want to play?

You can do this in two different ways. Either *favorite* the videos and then choose to play only your favorites, or *limit the selection* of videos that you play. 

#### To play only favorites:
1. Open Aerial in System Preferences 
2. Favorite (by starring) the videos you want to play. You can favorite an entire selection by right clicking on the left hand panel)

<img width="254" alt=“Favorite from Panel src="https://user-images.githubusercontent.com/18543749/90850889-0422f280-e341-11ea-945a-4b86255a9e4c.png">

3. Click on the `On Rotation` tab in the sidebar (at the top)
4. At the top of System Preferences, click on the dropdown next the `Aerial current plays:` and select `Only Favorites`.

<img width="345" alt="Play Only Favorites" src="https://user-images.githubusercontent.com/18543749/90850948-33d1fa80-e341-11ea-8132-78f08a7ae9cc.png">

### To play a single category of videos:

1. Open Aerial in System Preferences 
2. Click on the `On Rotation` tab in the sidebar (at the top)
3. At the top of System Preferences, click on the dropdown next to `Aerial current plays:` and select `Location`, `Time`, `Scene`, or `Source` then select the proper sub-section to play. 
<img width="451" alt="Sub Menus" src="https://user-images.githubusercontent.com/18543749/90851180-ebffa300-e341-11ea-85ec-35b1ad7a7395.png">

### Have you cached the videos you want to play?

1. Open Aerial in System Preferences 
2. Click on the `On Rotation` tab in the sidebar (at the top)
3. Click ‘Download rotation’ on the top right (or right click on `On Rotation` in the sidebar and click `Cache missing videos`

<img width="220" alt="Download rotation" src="https://user-images.githubusercontent.com/18543749/90851831-db502c80-e343-11ea-865d-5b8a8cbecac6.png">  <img width="220" alt="Cache Missing Videos" src="https://user-images.githubusercontent.com/18543749/90851994-4ef23980-e344-11ea-9b52-fd0fa783a10b.png">

<hr>

## My Cache is too large/small

Aerial can cache videos in two different ways:
- *Manually* 
- *Automatically*

When caching is set to **manual** you will need to download and manage your cache entirely manually. When set to **automatic**, you can set the size of your cache and Aerial will fill it with the videos you love! 

<h3> Manual Cache Management</h3>

1. Open Aerial in System Preferences 
2. Click on the settings tab (gear at the top of the sidebar)
3. Click on `Cache` on the sidebar
4. Uncheck 'Automatically download videos` 
<img width="400" alt="Manual management" src="https://user-images.githubusercontent.com/18543749/90852090-9678c580-e344-11ea-8f9f-7e6e3868778c.png">

5. Now download any videos you want to cache manually. 
6. Note that this may take up a significant amount of disk space. To delete or prune your cache, click the `Show in Finder` button and delete any videos you no longer want. 

### Automatic Cache Management
1. Open Aerial in System Preferences 
2. Click on the settings tab (gear at the top of the sidebar)
3. Click on `Cache` on the sidebar
4. Check 'Automatically download videos` 
<img width="400" alt="Automatic management" src="https://user-images.githubusercontent.com/18543749/90852209-e35c9c00-e344-11ea-9505-481789a581d7.png">

5. Set your **cache limit size** - This is the *MAXIMUM* size you want your cache. If you don't want to set a maximum, move the slider all the way to the right.
6. Select how often you want to rotate your videos in your cache 

<img width="200" alt="Rotate videos" src="https://user-images.githubusercontent.com/18543749/90852283-14d56780-e345-11ea-9ec5-7817cefc1d04.png">

> **NOTE:** if you have fewer videos selected than your cache size limit, videos will not rotate. If your cache is larger than your limit, then over the course of the selected time period your cache will be automatically pruned until you are under your cache limit and then videos will periodically rotate) 

<hr>

## What video format should I select?

This can be a complicated question, however we have written about it extensively [here](https://github.com/JohnCoates/Aerial/blob/master/Documentation/HardwareDecoding.md). 

The short answer is: 
- If you have an older Mac (2011-2014) you should use 1080 H.264. 
- If your Mac is 2015-2017 consider use of 1080 HEVC. 
- If you have a newer Mac (Late 2017-present) you can consider using 1080 HEVC, HDR, or, if you have more than 8GB of RAM you can give 4K a shot! 
> **NOTE:** 4K HDR requires the most intensive processing and requires a HDR compatible monitor.

#### To change the format of your videos:

*Skip to step 4 if you have not downloaded any videos yet*

1. If you have previously downloaded/cached videos please open Aerial Settings and click on "Advanced" in the sidebar. Click on "Show Log in Finder" 

<img width="500" alt="Cache Access" src="https://user-images.githubusercontent.com/18543749/90925120-bcdb4700-e3be-11ea-92a4-93c79756aab2.png">

2. Inside this folder, click on the `Cache` folder 
3. Keep the folder, but delete all content inside. Then empty your trash. 
4. Go to Aerial > Settings > Advanced
5. Select your preferred video format

<img width="200" alt="Screen Shot 2020-08-21 at 3 00 11 PM" src="https://user-images.githubusercontent.com/18543749/90925319-05930000-e3bf-11ea-8027-b555c178f931.png">

6. Close and relaunch System Preferences. 
7. Open Aerial Settings again and select the videos you want. Then download (cache) these videos and they will download in the selected format.

<hr>

<h2>What is "Download Rotation" and should I click it?</h2>

The `Download Rotation` button is visible under the `On Rotation` tab on the left. 

<img width="400" alt="Download Rotation" src="https://user-images.githubusercontent.com/18543749/90960980-962b1800-e473-11ea-8224-d9fe1907c14e.png">

Videos in Aerial only play when they are cached on your computer. This allows them to play while you are not connected to the internet and always play immediately when your screen saver starts. 

> Previous versions of Aerial could "stream" videos without downloading a cache, but this was replaced in 2.0 with the automatic cache management tool. 

The download rotation button is synonomous with saying "Cache my rotation". In other words, any videos in the `On Rotation` category on the left hand panel will begin to download to your computer when you click `Download Rotation`. 

> <b>NOTE:</b> Only videos that are cached AND that are shown in the `On Rotation` tab will play when you start your screen saver. 

In the event that you want to download videos from a specific category (for example if you want to select only certain videos to play) you can additionally right click on any category and select "Cache missing videos" 

> <b>NOTE:</b> If this option is not available, it is because you have already downloaded these videos!

<img width="200" alt="Cache Missing Videos" src="https://user-images.githubusercontent.com/18543749/90961135-c32bfa80-e474-11ea-8cf1-dd2abcc2d817.png">

<hr>

<h2> Where is tvOS 11 and 12?</h2>

All the videos are still available in Aerial, don't worry!

Aerial 2.0 takes advantage of the latest available videos from tvOS. tvOS 11 and 12 are not shown as tvOS 13 actually contains these videos! 

tvOS 10 videos support <b>1080p</b> quality while tvOS 13 can support <b>4K</b> and <b>4K HDR</b> videos. You can still play videos from tvOS 13 in <b>1080p</b> as well. 

<img width="150" alt="tvOS" src="https://user-images.githubusercontent.com/18543749/90963789-e2348780-e488-11ea-859f-8a01dfa8d3fb.png">

<hr>

<h2> I have more technical questions...</h2>

This FAQ was made largely to help those who are new to Aerial and GitHub. If you have more technical questions you need answered, please visit our Additional Documentation avaialble <a href="https://github.com/JohnCoates/Aerial/tree/master/Documentation#welcome-to-aerials-documentation">here</a>

